

/**
 * A semaphore is a passive object that guards a critical section of code
 * and reacts to p() and v() actions 
 * 
 * @author Bernd J. Krmer
 * @version 20.01.02
 */

public class Semaphore
{
    private int value;

    public Semaphore(int initial) 
    {
        if (initial < 0) 
        {
            throw new IllegalArgumentException("initial<0");
        }
        value = initial;
    }

    public synchronized void p() throws InterruptedException
    {
        while (value == 0)
        {
            wait();
        } 
        --value;
    }

    public synchronized void v() 
    { 
        ++value; 
        notify();  
    } 

    public synchronized String toString() 
    {
        return String.valueOf(value);
    }                            
}