
/**
 * Implements a bounded buffer whose capacity is specified upon creation time.
 * Methods get() and put() are implemented as monitors to ensure 
 * mutual exclusion of buffer accesses
 * 
 * @author BerndJ. Krmer
 * @version 10.01.02
 */

public final class BBuffer implements BoundedBuffer 
{
    private Object[] buffer;    // maintains the elements
    private int in = 0;         // circular index pointing at next slot to put elem
    private int out = 0;        // circular index pointing at slot to get elem from
    private int count = 0;      // used slot counts
    private boolean moreData = true; // flag used to stop the threads

    public BBuffer(int capacity) throws IllegalArgumentException 
    {
        if (capacity <= 0) throw new IllegalArgumentException();
        buffer = new Object[capacity];
    }

    public void setMoreData( boolean b ) 
    { 
        moreData = b; 
    }

    public boolean hasMoreData()
    {
        return moreData;
    }

    public boolean empty() { return (count == 0); }

    public boolean full() { return (count == capacity()); }

    public int count() { return count; }

    public int capacity() { return buffer.length; }

    public synchronized void put(Object o) throws InterruptedException
    { 
        while ( full() ) wait();  
        buffer[in] = o;
        ++count;
//        if ( full() )
//            System.out.println ( "Buffer full after next put() " +
//                                 "unless get() occurs!" );
        in = (in + 1) % capacity();
        notifyAll();
    }
    

    public synchronized Object get() throws InterruptedException    
    { 
        Object o = null; // return value
        while ( empty() ) wait(); 
        o = buffer[out];
        buffer[out] = null;
        --count;
//        if ( count == 0 )
//            System.out.println ( "Buffer empty after next get() " + 
//                                 "unless put() occurs!" );
        out = (out + 1) % capacity();
        notifyAll();
        return o;
    }
}

