
/**
 * Interface BoundedBuffer introduces two methods put() and get() to add or
 * remove an object from a BoundedBuffer object. 
 * Methods capacity() serves to determine the maximum number of 
 * objects to be stored in the buffer, while count() returns the actual 
 * number of stored objects
 *
 * @author Bernd Krmer
 * @version 18.01.02
 */

public interface BoundedBuffer
{
    public int    capacity();       
    public int    count();          // invariant: 0 <= count <= capacity()
    public boolean empty();         // count() == 0
    public boolean full();          // count == capacity()
    public void   put(Object x)     // add only when count < capacity()
                    throws InterruptedException;    
    public Object get()             // remove only when count > 0
                    throws InterruptedException;    
}
