
/**
 * Consumer continuously reads from a buffer shared with other Consumers and Producers.
 * A random sleep time between 0 and 2 seconds serves to illustrate their interaction
 * The data we use to communicate between producers and consumers are characters 
 * extracted from a String communicated to a Producer object upon its creation
 * 
 * @author Bernd J. Krmer
 * @version 18.0102
 */
public class Consumer extends Thread
{
    // the buffer from which data produced by some Producer thread are retrieved
    private BBuffer buffer;

    /**
     * Constructor for objects of class Consumer
     */
    public Consumer( BBuffer b, String name )
    {
        buffer = b;
        this.setName( name );
    }

    public void run()
    {
        Character c; 
        while ( true )
        {
            try
            {   //goto sleep for a random amount time interval between  
                Thread.sleep ( (int) (Math.random() * 1500 ) ); // 0 and 1.5 seconds
            }
            catch ( InterruptedException e )
            {
                System.err.println ( e.toString() );
            }
            try
            {
                c = (Character) buffer.get();
                System.out.println ( "Consumer " + this.getName() + 
                                     " retrieved " + c );
            }
            catch ( InterruptedException e )
            {
                System.err.println ( e.toString() );
            }
        }
    }
}
