
/**
 * A Producer continuously generates a character and puts it in buffer 
 * shared with concurrently acting Consumers and other Producers.
 * A random sleep time between 0 and 2 seconds serves to illustrate 
 * their interaction
 * 
 * @author Bernd J. Krmer
 * @version 18.0102
 */
public class Producer extends Thread
{
    // the buffer in which data produced are stored
    private BBuffer buffer;
    private String quarry;
    private int cycles;

    /**
     * Constructor for objects of class Consumer
     */
    public Producer( BBuffer b, String s, String name, int n)
    {
        buffer = b;
        quarry = s;
        this.setName( name );
        cycles = n;
    }

    public void run()
    {
        int next = 0; // circular index to the quarry String 
        Character c; // we use a wrapper to turn a char into an object 

        for ( int count = 0; count < cycles; count++ )
        {
           
            try
            {   //goto sleep for a random amount time interval between  
                Thread.sleep ( (int) (Math.random() * 2000 ) ); // 0 and 2 seconds
            }
            catch ( InterruptedException e )
            {
                System.err.println ( e.toString() );
            }
            try
            {
                c = new Character( quarry.charAt(next) );
                buffer.put ( c );
                System.out.println ( "Producer " + this.getName() + 
                                     " generated and stored " + c );
                next = (next + 1) % quarry.length();
            }
            catch ( InterruptedException e )
            {
                System.err.println ( e.toString() );
            }
        }
        System.out.println ( "Thread " + this.getName() + 
                                 " going to terminate" );
        buffer.setMoreData( false ); // terminate the production consumtion process
    }
}
