
/**
 * Class ProducerConsumerInteraction provides the framework for running
 * a Producer-Consumer configuration.
 * 
 * @author Bernd J. Krmer
 * @version 18.01.02
 */
public class ProducerConsumerInteraction
{
    public void go( int capacity, int cycles ) throws IllegalArgumentException 
    {
        if (cycles <= 0) throw new IllegalArgumentException();
        System.out.println( "Capacity: " + capacity + ", Cycles: " + cycles );
        BBuffer buffer = new BBuffer( capacity );
        Consumer consumer = new Consumer ( buffer, "Consumer" );
        Producer producerUC = new Producer ( buffer, 
                                             "ABCDEFGHIJKLMNOPQRSTUVWXYZ",
                                             "UpperCase", cycles );
        Producer producerLC = new Producer ( buffer, 
                                             "abcdefghijklmnopqrstuvwxyz",
                                             "LowerCase", cycles );
        consumer.start();
        producerUC.start();
        producerLC.start();
    }
}
